% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensional_reduction_utilities.R
\name{ICAEmbed}
\alias{ICAEmbed}
\title{ICA Cell Embeddings Accessor Function}
\usage{
ICAEmbed(object, dims.use = NULL, cells.use = NULL)
}
\arguments{
\item{object}{Seurat object}

\item{dims.use}{Dimensions to include (default is all stored dims)}

\item{cells.use}{Cells to include (default is all cells)}
}
\value{
ICA cell embeddings matrix for given cells and ICs
}
\description{
Pull ICA cell embeddings matrix
}
\examples{
pbmc_small
pbmc_small <- RunICA(pbmc_small, ics.compute = 10, ics.print = 0)
head(ICAEmbed(pbmc_small))
# Optionally, you can specify subsets of dims or cells to use
ICAEmbed(pbmc_small, dims.use = 1:5, cells.use = pbmc_small@cell.names[1:5])

}
