% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensional_reduction_utilities.R
\name{GetGeneLoadings}
\alias{GetGeneLoadings}
\title{Dimensional Reduction Gene Loadings Accessor Function}
\usage{
GetGeneLoadings(object, reduction.type = "pca", dims.use = NULL,
  genes.use = NULL, use.full = FALSE)
}
\arguments{
\item{object}{Seurat object}

\item{reduction.type}{Type of dimensional reduction to fetch (default is PCA)}

\item{dims.use}{Dimensions to include (default is all stored dims)}

\item{genes.use}{Genes to include (default is all genes)}

\item{use.full}{Return projected gene loadings (default is FALSE)}
}
\value{
Gene loading matrix for given reduction, cells, and genes
}
\description{
Pull gene loadings matrix for specified stored dimensional reduction analysis.
}
\examples{
pbmc_small
# Examine the head of the first 5 PC gene loadings
head(GetGeneLoadings(object = pbmc_small, reduction.type = "pca", dims.use = 1:5))

}
