% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensional_reduction.R
\name{RunCCA}
\alias{RunCCA}
\title{Perform Canonical Correlation Analysis}
\usage{
RunCCA(object, object2, group1, group2, group.by, num.cc = 20, genes.use,
  scale.data = TRUE, rescale.groups = FALSE, ...)
}
\arguments{
\item{object}{Seurat object}

\item{object2}{Optional second object. If object2 is passed, object1 will be
considered as group1 and object2 as group2.}

\item{group1}{First set of cells (or IDs) for CCA}

\item{group2}{Second set of cells (or IDs) for CCA}

\item{group.by}{Factor to group by (column vector stored in object@meta.data)}

\item{num.cc}{Number of canonical vectors to calculate}

\item{genes.use}{Set of genes to use in CCA. Default is object@var.genes. If
two objects are given, the default is the union of both variable gene sets
that are also present in both objects.}

\item{scale.data}{Use the scaled data from the object}

\item{rescale.groups}{Rescale each set of cells independently}

\item{...}{Extra parameters (passed onto MergeSeurat in case with two objects
passed, passed onto ScaleData in case with single object and rescale.groups
set to TRUE)}
}
\value{
Returns Seurat object with the CCA stored in the @dr$cca slot. If
one object is passed, the same object is returned. If two are passed, a
combined object is returned.
}
\description{
Runs a canonical correlation analysis using a diagonal implementation of CCA.
For details about stored CCA calculation parameters, see
\code{PrintCCAParams}.
}
\examples{
pbmc_small
# As CCA requires two datasets, we will split our test object into two just for this example
pbmc1 <- SubsetData(pbmc_small,cells.use = pbmc_small@cell.names[1:40])
pbmc2 <- SubsetData(pbmc_small,cells.use = pbmc_small@cell.names[41:80])
pbmc1@meta.data$group <- "group1"
pbmc2@meta.data$group <- "group2"
pbmc_cca <- RunCCA(pbmc1,pbmc2)
# Print results
PrintDim(pbmc_cca,reduction.type = 'cca')

}
\seealso{
\code{MergeSeurat}
}
