% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{FilterCells}
\alias{FilterCells}
\title{Return a subset of the Seurat object}
\usage{
FilterCells(object, subset.names, low.thresholds, high.thresholds,
  cells.use = NULL)
}
\arguments{
\item{object}{Seurat object}

\item{subset.names}{Parameters to subset on. Eg, the name of a gene, PC1, a
column name in object@meta.data, etc. Any argument that can be retreived
using FetchData}

\item{low.thresholds}{Low cutoffs for the parameters (default is -Inf)}

\item{high.thresholds}{High cutoffs for the parameters (default is Inf)}

\item{cells.use}{A vector of cell names to use as a subset}
}
\value{
Returns a Seurat object containing only the relevant subset of cells
}
\description{
Creates a Seurat object containing only a subset of the cells in the
original object. Takes either a list of cells to use as a subset, or a
parameter (for example, a gene), to subset on.
}
\examples{
head(x = FetchData(object = pbmc_small, vars.all = 'LTB'))
pbmc_filtered <- FilterCells(
  object = pbmc_small,
  subset.names = 'LTB',
  high.thresholds = 6
)
head(x = FetchData(object = pbmc_filtered, vars.all = 'LTB'))

}
