% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_determination.R
\name{DoKMeans}
\alias{DoKMeans}
\title{K-Means Clustering}
\usage{
DoKMeans(object, genes.use = NULL, k.genes = NULL, k.cells = 0,
  k.seed = 1, do.plot = FALSE, data.cut = 2.5,
  k.cols = PurpleAndYellow(), set.ident = TRUE, do.constrained = FALSE,
  assay.type = "RNA", ...)
}
\arguments{
\item{object}{Seurat object}

\item{genes.use}{Genes to use for clustering}

\item{k.genes}{K value to use for clustering genes}

\item{k.cells}{K value to use for clustering cells (default is NULL, cells
are not clustered)}

\item{k.seed}{Random seed}

\item{do.plot}{Draw heatmap of clustered genes/cells (default is FALSE).}

\item{data.cut}{Clip all z-scores to have an absolute value below this.
Reduces the effect of huge outliers in the data.}

\item{k.cols}{Color palette for heatmap}

\item{set.ident}{If clustering cells (so k.cells>0), set the cell identity
class to its K-means cluster (default is TRUE)}

\item{do.constrained}{FALSE by default. If TRUE, use the constrained K-means function implemented in the tclust package.}

\item{assay.type}{Type of data to normalize for (default is RNA), but can be changed for multimodal analyses.}

\item{\dots}{Additional parameters passed to kmeans (or tkmeans)}
}
\value{
Seurat object where the k-means results for genes is stored in
object@kmeans.obj[[1]], and the k-means results for cells is stored in
object@kmeans.col[[1]]. The cluster for each cell is stored in object@meta.data[,"kmeans.ident"]
and also object@ident (if set.ident=TRUE)
}
\description{
Perform k=means clustering on both genes and single cells
}
\details{
K-means and heatmap are calculated on object@scale.data
}
\examples{
pbmc_small
# Cluster on genes only
pbmc_small <- DoKMeans(pbmc_small, k.genes = 3)
# Cluster on genes and cell
pbmc_small <- DoKMeans(pbmc_small, k.genes = 3, k.cells = 3)

}
