/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class Clustering
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int nNodes;
    protected int nClusters;
    protected int[] cluster;

    public static Clustering load(String string) throws ClassNotFoundException, IOException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(string));
        Clustering clustering = (Clustering)objectInputStream.readObject();
        objectInputStream.close();
        return clustering;
    }

    public Clustering(int n) {
        this.nNodes = n;
        this.cluster = new int[n];
        this.nClusters = 1;
    }

    public Clustering(int[] nArray) {
        this.nNodes = nArray.length;
        this.cluster = (int[])nArray.clone();
        this.nClusters = Arrays2.calcMaximum(nArray) + 1;
    }

    public Object clone() {
        try {
            Clustering clustering = (Clustering)super.clone();
            clustering.cluster = this.getClusters();
            return clustering;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void save(String string) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string));
        objectOutputStream.writeObject(this);
        objectOutputStream.close();
    }

    public int getNNodes() {
        return this.nNodes;
    }

    public int getNClusters() {
        return this.nClusters;
    }

    public int[] getClusters() {
        return (int[])this.cluster.clone();
    }

    public int getCluster(int n) {
        return this.cluster[n];
    }

    public int[] getNNodesPerCluster() {
        int[] nArray = new int[this.nClusters];
        for (int i = 0; i < this.nNodes; ++i) {
            int n = this.cluster[i];
            nArray[n] = nArray[n] + 1;
        }
        return nArray;
    }

    public int[][] getNodesPerCluster() {
        int n;
        int[][] nArrayArray = new int[this.nClusters][];
        int[] nArray = this.getNNodesPerCluster();
        for (n = 0; n < this.nClusters; ++n) {
            nArrayArray[n] = new int[nArray[n]];
            nArray[n] = 0;
        }
        for (n = 0; n < this.nNodes; ++n) {
            nArrayArray[this.cluster[n]][nArray[this.cluster[n]]] = n;
            int n2 = this.cluster[n];
            nArray[n2] = nArray[n2] + 1;
        }
        return nArrayArray;
    }

    public void setCluster(int n, int n2) {
        this.cluster[n] = n2;
        this.nClusters = Math.max(this.nClusters, n2 + 1);
    }

    public void initSingletonClusters() {
        for (int i = 0; i < this.nNodes; ++i) {
            this.cluster[i] = i;
        }
        this.nClusters = this.nNodes;
    }

    public void orderClustersByNNodes() {
        int n;
        int[] nArray = this.getNNodesPerCluster();
        class ClusterNNodes
        implements Comparable<ClusterNNodes> {
            public int cluster;
            public int nNodes;

            public ClusterNNodes(int n, int n2) {
                this.cluster = n;
                this.nNodes = n2;
            }

            @Override
            public int compareTo(ClusterNNodes clusterNNodes) {
                return clusterNNodes.nNodes > this.nNodes ? 1 : (clusterNNodes.nNodes < this.nNodes ? -1 : 0);
            }
        }
        Object[] objectArray = new ClusterNNodes[this.nClusters];
        for (n = 0; n < this.nClusters; ++n) {
            objectArray[n] = new ClusterNNodes(n, nArray[n]);
        }
        Arrays.sort(objectArray);
        int[] nArray2 = new int[this.nClusters];
        n = 0;
        do {
            nArray2[((ClusterNNodes)objectArray[n]).cluster] = n;
        } while (++n < this.nClusters && ((ClusterNNodes)objectArray[n]).nNodes > 0);
        this.nClusters = n;
        for (n = 0; n < this.nNodes; ++n) {
            this.cluster[n] = nArray2[this.cluster[n]];
        }
    }

    public void mergeClusters(Clustering clustering) {
        for (int i = 0; i < this.nNodes; ++i) {
            this.cluster[i] = clustering.cluster[this.cluster[i]];
        }
        this.nClusters = clustering.nClusters;
    }
}

