% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensional_reduction.R
\name{ProjectDim}
\alias{ProjectDim}
\title{Project Dimensional reduction onto full dataset}
\usage{
ProjectDim(object, reduction.type = "pca", dims.print = 1:5,
  dims.store = 30, genes.print = 30, replace.dim = FALSE,
  do.center = FALSE, do.print = TRUE, assay.type = "RNA")
}
\arguments{
\item{object}{Seurat object}

\item{reduction.type}{Reduction to use}

\item{dims.print}{Number of dims to print genes for}

\item{dims.store}{Number of dims to store (default is 30)}

\item{genes.print}{Number of genes with highest/lowest loadings to print for
each PC}

\item{replace.dim}{Replace the existing data (overwrite
object@dr$XXX@gene.loadings), not done by default.}

\item{do.center}{Center the dataset prior to projection (should be set to TRUE)}

\item{do.print}{Print top genes associated with the projected dimensions}

\item{assay.type}{Data type, RNA by default. Can be changed for multimodal
datasets (i.e. project a PCA done on RNA, onto CITE-seq data)}
}
\value{
Returns Seurat object with the projected values in
object@dr$XXX@gene.loadings.full
}
\description{
Takes a pre-computed dimensional reduction (typically calculated on a subset
of genes) and projects this onto the entire dataset (all genes). Note that
the cell loadings will remain unchanged, but now there are gene loadings for
all genes.
}
\examples{
pbmc_small
pbmc_small <- ProjectDim(pbmc_small, reduction.type = "pca")
# Vizualize top projected genes in heatmap
DimHeatmap(pbmc_small,pc.use = 1,use.full = TRUE,do.balanced = TRUE,reduction.type = "pca")

}
