\name{SCHLF}
\alias{SCHLF}
\docType{data}
\title{Schneider et. al. (2010)}
\description{The \code{SCHLF} data frame has 76 observations and 9 variables.}
\usage{data(SCHLF)}
\format{
  A data frame with 76 observations on the following 9 variables.
  \describe{
    \item{\code{EMP}}{a numeric vector. Condition, employment protection.}
    \item{\code{BARGAIN}}{a numeric vector. Condition, collective bargaining.}
    \item{\code{UNI}}{a numeric vector. Condition, university training.}
    \item{\code{OCCUP}}{a numeric vector. Condition, occupational training.}
    \item{\code{STOCK}}{a numeric vector. Condition, stock market size.}
    \item{\code{MA}}{a numeric vector. Condition, mergers and acquisitions.}
    \item{\code{EXPORT}}{a numeric vector. Outcome, export performance in high-tech industries.}
    \item{\code{COUNTRY}}{a string vector. Name of the country in which the observation was made.}
    \item{\code{YEAR}}{a numeric vector. Year in which the observation was made.}
  }
}
\details{Data used by Schneider et. al. (2010) to explain capitalist variety 
and export performance in high-tech industries. Data is saved in the long format and the first 7 variables are fuzzy-sets.}

\references{Schneider, M. R., Schulze-Bentrop, C., Paunescu, M. (2010) "Mapping the institutional capital of high-tech firms: A fuzzy-set analysis of capitalist variety and export performance", Journal of International Business Studies 41, pp. 246:266;
	
Schneider, C. Q., Wagemann, C. (2012) Set-Theoretic Methods for the Social Sciences, Cambridge University Press: Cambridge.

}
\examples{data(SCHLF)}
\keyword{datasets}
