% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotSentiment}
\alias{plotSentiment}
\title{Line plot with sentiment scores}
\usage{
plotSentiment(
  sentiment,
  x = NULL,
  cumsum = FALSE,
  xlab = "",
  ylab = "Sentiment"
)
}
\arguments{
\item{sentiment}{\code{data.frame} or numeric vector with sentiment scores}

\item{x}{Optional parameter with labels or time stamps on x-axis.}

\item{cumsum}{Parameter deciding whether the cumulative sentiment
is plotted (default: \code{cumsum=FALSE}).}

\item{xlab}{Name of x-axis (default: empty string).}

\item{ylab}{Name of y-axis (default: "Sentiment").}
}
\value{
Returns a plot of class \code{\link[ggplot2]{ggplot}}
}
\description{
Simple line plot to visualize the evolvement of sentiment scores.
This is especially helpful when studying a time series of
sentiment scores.
}
\examples{
sentiment <- data.frame(Dictionary=runif(20))

plotSentiment(sentiment)
plotSentiment(sentiment, cumsum=TRUE)

# Change name of x-axis
plotSentiment(sentiment, xlab="Tone")

library(ggplot2)
# Extend plot with additional layout options
plotSentiment(sentiment) + ggtitle("Evolving sentiment")
plotSentiment(sentiment) + theme_void() 
}
\seealso{
\code{\link{plotSentimentResponse}} and \code{\link{plot.SentimentDictionaryWeighted}} for further plotting options
}
\keyword{evaluation}
\keyword{plots}
