% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_feature_seqs.R
\name{get_feature_seqs}
\alias{get_feature_seqs}
\title{Get transcripts features and feature sequences}
\usage{
get_feature_seqs(tx.db, dna, feature.type = "3UTR")
}
\arguments{
\item{tx.db}{A tx.db object}

\item{dna}{A 2bit dna sequence}

\item{feature.type}{The type of feature to return. Options: 3UTR, 5UTR,
exons, introns, cds}
}
\value{
list containing the feature db object and the feature sequences
}
\description{
This function is used to get the genomic features of interest
and the DNA sequences associated with them. This function takes advantage of
the \code{GenomicFeatures} package functions \code{threeUTRsByTranscript},
\code{fiveUTRsByTranscript}, \code{exonsBy}, \code{intronsByTranscript}, and \code{cdsBy}. These
functions are used to generate the features given an input \code{tx.db} object. A
2bit \code{dna} input is also required for extracting features sequences.

The output of the this function is:
\itemize{
\item \verb{$db}: the feature \code{GRanges} object
\item \verb{$seqs}: \code{DNAStringSet} of sequences associated to those features
}
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
anno.db = load_species_anno_db("human")

features = get_feature_seqs(anno.db$tx.db, anno.db$dna)
\dontshow{\}) # examplesIf}
}
