% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCORE.R
\name{SCORE}
\alias{SCORE}
\title{community detection method called SCORE
Spectral Clustering On Ratios-of-Eigenvectors (SCORE)}
\usage{
SCORE(A, K, threshold = NULL)
}
\arguments{
\item{A}{n-by-n binary symmtric adjacency matrix.}

\item{K}{number of communities.}

\item{threshold}{(optional) the threshold of ratio matrix. By defalt is \code{log(n)}.}
}
\value{
A list containing \describe{
  \item{R}{n-by-(K-1) ratio matrix.}
  \item{labels}{A vector of integer indicating the cluster to which each point allocated.}
}
}
\description{
community detection method called SCORE
Spectral Clustering On Ratios-of-Eigenvectors (SCORE)
}
\examples{
library(igraphdata)
library(igraph)
data('karate')
A = get.adjacency(karate)
karate.out = SCORE(A, 2)
karate.out$labels
}
