% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bootstrap.R
\encoding{UTF-8}
\name{Bootstrap}
\alias{Bootstrap}
\alias{Bootstrap.default}
\alias{Bootstrap.model}
\title{Method for Bootstrapping}
\usage{
Bootstrap(x, ...)

\method{Bootstrap}{default}(x, nboots = 30, FUN, ...)

\method{Bootstrap}{model}(x, ...)
}
\arguments{
\item{x}{is a vector or a fitted model object whose parameters will be used to produce bootstrapped statistics. Model objects are assumed to be of class \dQuote{glm} or \dQuote{lm}.}

\item{nboots}{an integer for the number of reiteration.}

\item{FUN}{a statistic function name to bootstrap, i.e., 'mean', 'var', 'cov', etc.}

\item{\dots}{further arguments passed to or used by other methods.}
}
\value{
A list with \dQuote{alpha} and \dQuote{beta} slots. The \dQuote{alpha}
 corresponds to ancillary parameters and \dQuote{beta} to systematic components
 of the model.
}
\description{
this method provides bootstrapping statistics.
}
\examples{
x = runif(10, 0, 1)
Bootstrap(x, FUN=mean)

}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}
}
\keyword{Modelling}

