% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gini.simpson.R
\encoding{UTF-8}
\name{gini.simpson}
\alias{gini.simpson}
\title{Gini-Simpson Index}
\usage{
gini.simpson(x, na.rm = TRUE)

gini.simpson(x, na.rm = TRUE)
}
\arguments{
\item{x}{A data.frame, a matrix-like, or a vector.}

\item{na.rm}{A logical value to deal with NAs.}

\item{\dots}{Additional arguements (currently ignored)}
}
\description{
Computes the Gini/Simpson coefficient. \code{NA}s from the data are omitted.
}
\details{
The Gini-Simpson quadratic index is a classic measure of diversity, widely used by social scientists and ecologists. The Gini-Simpson is also known as Gibbs-Martin index in sociology, psychology and management studies, which in turn is also known as the Blau index. The Gini-Simpson index is computed as \eqn{1 - \lambda = 1 - \sum_{i=1}^R p_i^2 = 1 - 1/{}^2D}.
}
\examples{
# generate a vector (of incomes)
x <- as.table(c(69,50,40,22))
rownames(x) <- c("AB","C","D","E")
gini.simpson(x)
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}.
}
\seealso{
\code{\link{politicalDiversity}}.
}
\keyword{Concentration,}
\keyword{Diversity,}
\keyword{Inequality}

