% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/se.R
\docType{methods}
\encoding{UTF-8}
\name{se}
\alias{se}
\alias{se,ANY-method}
\alias{se,numeric,logical,ANY-method}
\title{Calculates the Standard Error}
\usage{
se(x, na.rm = TRUE)

\S4method{se}{ANY}(x, na.rm = TRUE)
}
\arguments{
\item{x}{A vector of class numeric or integer}

\item{na.rm}{A logical value for \code{na.rm}, default is \code{na.rm=TRUE}.}
}
\description{
Compute the standard errors of a numeric vector
}
\details{
The standard error of the mean (SEM) (\emph{assuming statistical independence of the values in the sample}) is estimated by taking the standard deviation of the population sample, divided by the square root of the sample size: \deqn{se = \frac{{s}}{{\sqrt{n}}}}
}
\examples{
x <- c(1, 2.3, 2, 3, 4, 8, 12, 43, -1,-4)
myse <- sd(x)/sqrt(length(x))
myse
# With the 'se' function:
se(x)
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}
}

