% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssc_propcomp.R
\name{ssc_propcomp}
\alias{ssc_propcomp}
\title{Sample Size Calculation for the Comparison of Proportions in Phase III Clinical Trials}
\usage{
ssc_propcomp(design=c(1,2,3,4), ratio, alpha, power, p1, p2, theta, delta)
}
\arguments{
\item{design}{The design of the clinical trials.
\cr 1
  \cr Testing for equality
\cr 2
  \cr Superiority trial
\cr 3
  \cr Non-inferiority trial
\cr 4
  \cr Equivalence trial.}

\item{ratio}{The ratio between the number of subjects in the treatment arm and that in the control arm.}

\item{alpha}{Type I error rate}

\item{power}{Statistical power of the test (1-type II error rate)}

\item{p1}{The response rate of the treatment arm}

\item{p2}{The response rate of the control arm}

\item{theta}{The difference between proportions in the two arms}

\item{delta}{The prespecified non-inferiority or equivalence margin in non-inferiority (3) or equivalence (4) trials}
}
\value{
samplesize
}
\description{
This function aims to calculate sample size for the comparison of proportions
in Phase III clinical trials.
}
\examples{
##The comparison of proportions, a superiority trial
ssc_propcomp(design=2, ratio=3, alpha=0.025, power=0.8, p1=0.4, p2=0.2, theta=0.2)
}
\references{
Yin, G. (2012). Clinical Trial Design: Bayesian and Frequentist Adaptive Methods. John Wiley & Sons.
}
