% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/point2poly_simp.R
\name{point2poly_simp}
\alias{point2poly_simp}
\title{Point-to-polygon interpolation, simple overlay method}
\usage{
point2poly_simp(
  pointz,
  polyz,
  varz,
  char_varz = NULL,
  funz = list(function(x) {     sum(x, na.rm = TRUE) }),
  na_val = NA,
  drop_na_cols = FALSE
)
}
\arguments{
\item{pointz}{Source points layer. \code{sf} object.}

\item{polyz}{Destination polygon layer. Must have identical CRS to \code{pointz}. \code{sf} object.}

\item{varz}{Names of variable(s) to be assigned from source polygon layer to destination polygons. Character string or vector of character strings.}

\item{char_varz}{Names of character string variable(s) in \code{varz}. Character string or vector of character strings.}

\item{funz}{Aggregation function to be applied to variables specified in \code{varz}. Must take as an input a vector \code{x}. Function or list of functions.}

\item{na_val}{Value to be assigned to missing values. Defaul is \code{NA}. Logical or list.}

\item{drop_na_cols}{Drop columns with completely missing values. Defaul is \code{FALSE}. Logical.}
}
\value{
Returns a \code{sf} polygon object, with variables from \code{pointz} assigned to the geometries of \code{polyz}.
}
\description{
Function for assigning values from a source point layer to a destination polygon layer, using simple point-in-polygon overlays
}
\details{
Assignment procedures are the same for numeric and character string variables. All variables supplied in \code{varz} are passed directly to the function specified in \code{funz}. If different sets of variables are to be aggregated with different functions, both \code{varz} and \code{funz} should be specified as lists (see examples below).
}
\examples{
# Assignment of a single variable (sums)
\dontrun{
data(hex_05_deu)
data(clea_deu2009_pt)
out_1 <- point2poly_simp(pointz=clea_deu2009_pt,
                         polyz=hex_05_deu,
                         varz="vv1")
plot(out_1["vv1"])
}

# Replace NA's with 0's
\dontrun{
out_2 <- point2poly_simp(pointz = clea_deu2009_pt,
                         polyz = hex_05_deu,
                         varz = "vv1",
                         na_val = 0)
plot(out_2["vv1"])
}

# Multiple variables, with different assignment functions
\dontrun{
out_3 <- point2poly_simp(pointz = clea_deu2009_pt,
                         polyz = hex_05_deu,
                         varz = list(
                           c("to1","pvs1_margin"),
                           c("vv1"),
                           c("incumb_pty_n","win1_pty_n")),
                         funz = list(
                           function(x){mean(x,na.rm=TRUE)},
                           function(x){sum(x,na.rm=TRUE)},
                           function(x){paste0(unique(na.omit(x)),collapse=" | ") }),
                         na_val = list(NA_real_,0,NA_character_))
}
}
