% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCounts.R
\name{getCounts}
\alias{getCounts}
\title{Aggregate person-month data into counts and totals by groups.}
\usage{
getCounts(data, variables, by, ignore = NULL, addtotal = TRUE,
  drop = TRUE)
}
\arguments{
\item{data}{dataset in person-month format}

\item{variables}{a character vector of the variables to aggregate}

\item{by}{a character vector of columns that specifies which groups to aggregate by.}

\item{ignore}{list of conditions not to impute 0. If left unspecified, any group levels not in the data will be imputed to have 0 counts.}

\item{addtotal}{logical indicator of whether to add a column of group total counts.}

\item{drop}{logical indicator of whether to drop all rows with total = 0.}
}
\value{
data.frame of the ggregated counts.
}
\description{
Aggregate person-month data into counts and totals by groups.
}
\examples{

 
# a toy dataset with 4 time periods but one missing in data
timelist <- factor(1:4)
data = data.frame(died = c(0,0,0,1,1,0,0), 
					area = c(rep(c("A", "B"), 3), "A"), 
					time = timelist[c(1,1,2,3,3,3,3)])
data
# without ignore argument, all levels will be imputed
getCounts(data, variables = "died", by = c("area", "time"))

# ignoring time = 4, the ignored level will not be imputed (but still in the output)
getCounts(data, variables = "died", by = c("area", "time"), 
			ignore = list("time"=c(4)) )

 
}
\author{
Zehang Richard Li
}
