% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hatchPlot.R
\name{hatchPlot}
\alias{hatchPlot}
\title{Makes map plot with uncertainty hatching.}
\usage{
hatchPlot(data, variables, values = NULL, labels = NULL, geo, by.data,
  by.geo, is.long = FALSE, lower, upper, lim = NULL, lim.CI = NULL,
  breaks.CI = NULL, ncol = 4, hatch = NULL, border = NULL,
  size = 1, legend.label = NULL, per1000 = FALSE, ...)
}
\arguments{
\item{data}{a data frame with variables to be plotted}

\item{variables}{vector of variables to be plotted. If long format of data is used, only one variable can be selected}

\item{values}{the column corresponding to the values to be plotted, only used when long format of data is used}

\item{labels}{vector of labels to use for each variable, only used when wide format of data is used}

\item{geo}{\code{geo} output from \code{\link{read_shape}}}

\item{by.data}{column name specifying region names in the data}

\item{by.geo}{variable name specifying region names in the data}

\item{is.long}{logical indicator of whether the data is in the long format, default to FALSE}

\item{lower}{column name of the lower bound of the CI}

\item{upper}{column name of the upper bound of the CI}

\item{lim}{fixed range of values for the variables to plot}

\item{lim.CI}{fixed range of the CI widths to plot}

\item{breaks.CI}{a vector of numerical values that decides the breaks in the CI widths to be shown}

\item{ncol}{number of columns for the output tabs}

\item{hatch}{color of the hatching lines.}

\item{border}{color of the polygon borders.}

\item{size}{line width of the polygon borders.}

\item{legend.label}{Label for the color legend.}

\item{per1000}{logical indicator to plot mortality rates as rates per 1,000 live births. Note that the added comparison data should always be in the probability scale.}

\item{...}{unused.}
}
\description{
This function visualizes the map with different variables. The input data frame can be either the long or wide format.
}
\examples{
\dontrun{
years <- levels(DemoData[[1]]$time)

# obtain direct estimates
data <- getDirectList(births = DemoData, 
years = years,  
regionVar = "region", timeVar = "time", 
clusterVar = "~clustid+id", 
ageVar = "age", weightsVar = "weights", 
geo.recode = NULL)
# obtain direct estimates
data_multi <- getDirectList(births = DemoData, years = years,
  regionVar = "region",  timeVar = "time", clusterVar = "~clustid+id",
  ageVar = "age", weightsVar = "weights", geo.recode = NULL)
data <- aggregateSurvey(data_multi)

fit2 <- fitINLA(data = data, geo = geo, Amat = mat, 
  year_label = years.all, year_range = c(1985, 2019), 
  rw = 2, is.yearly=TRUE, m = 5, type.st = 4)
out2 <- getSmoothed(fit2, Amat = mat)

plot(out2, is.yearly=TRUE, is.subnational=TRUE)

hatchPlot(data = subset(out2, is.yearly==FALSE), geo = geo,
variables=c("years"), values = c("median"), 
by.data = "region", by.geo = "REGNAME", 
lower = "lower", upper = "upper", is.long=TRUE)

}
}
