% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ConstructMPst.R
\name{ConstructMPst}
\alias{ConstructMPst}
\title{Construct Spatio - temporal regular data.}
\usage{
ConstructMPst(valuest,time,pts,Delta)
}
\arguments{
\item{valuest}{it's a data.frame in which different columns refer to different locations, and each row reflects a particular observation time.}

\item{time}{indicate the time of valuest, the intervals of time must be regular.}

\item{pts}{it's a data.frame that hold three dimensions spatial coordinates  \code{x},  \code{y} and  \code{z}.}

\item{Delta}{vector with number of divisions of each spatial direction. c(Delta  \code{x}, Delta  \code{y}, Delta  \code{z}).}
}
\value{
An object of class ConstructMPst with the following list of components:

\item{results}{average value of the set of stations into unity spatio - temporal defined for delta.}

\item{Value}{array with the results organized in dimensions defined in Delta.}

\item{valuest}{valuest}

\item{pts}{pts}

\item{time}{time}

\item{Delta}{Delta}
}
\description{
Create an  spatio - temporal object with regular data to order employing median polish technique.
}
\details{
Table composed for coordinates of center and average of position of stations for unit tridimensional array in space - time, in which show a average value of site.
}
\examples{
## Not run:
data(Metadb)
x<-matrix(0,1,37)
for(i in 1:37){
 x[,i] <- 2007 + (seq(0, 36)/12)[i]
}
x<-as.Date (as.yearmon(x), frac = 1)
time = as.POSIXct(x, tz = "GMT")

MPST<-ConstructMPst(Metadb[,-c(1:4)],time,pts=Metadb[,2:4],Delta=c(7,6,5))
## End(Not run)
}
\references{
Berke, O. (2001). \emph{Modified median polish kriging and its application to the wolfcamp - aquifer data.} Environmetrics, 12(8):731-748.\href{http://onlinelibrary.wiley.com/doi/10.1002/env.495/abstract}{[link]}
}

