% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stb.R
\name{getSTB}
\alias{getSTB}
\title{Simultaneous Tolerance Bands Using R-Implementation.}
\usage{
getSTB(mat, alpha = 0.05, tol = 1e-04, max.iter = 100L, q.type = 2L,
  logfile = NULL, output = TRUE, timer = FALSE, Ncpu = 2)
}
\arguments{
\item{mat}{(numeric) matrix with nrow=N_simulation, ncol=N_points, where each row is sorted in increasing order}

\item{alpha}{(numeric) 100(1-alpha)\% simultaneous tolerance-level will be computed}

\item{tol}{(numeric) value controlling the termination of the bisection algorithm, i.e. the condition \code{coverage-(1-alpha)<=tol}
has to be TRUE.}

\item{max.iter}{(integer) maximum number of iterations of the bisection algorithm. If this number is reached the algorithm terminates
and returns the best approximation of lower and upper bounds reached up to this iteration.}

\item{q.type}{(integer) the quantile-type used if \code{algo="R"}, see ? quantile for details.}

\item{logfile}{(character) string specifying the name of the (optional) log-file, storing the iteration history}

\item{output}{(logical) TRUE a txtProgressBar will be printed as well as additional status information}

\item{timer}{(logical) TRUE = the time spent for computing the STB will be printed}

\item{Ncpu}{(integer) specifying the number cores/CPUs to be used in computing the coverage on C-level,
for N>1 multi-processing is applied}
}
\value{
(list) with elements:
\item{Q}{(numeric) matrix with two rows, where the 1st row = lower bounds of the STB, 2nd row = upper bounds of the STB}
\item{cov}{(numeric) value indicating the actual coverage of the STB}
}
\description{
Compute simultaneous tolerance bounds (STB) from a matrix.
}
\details{
Function computes 100(1-alpha)\% simultaneous tolerance bounds (intervals, bands) from a matrix, where rows correspond
to order statistics (sorted) of random samples of a, e.g. normal distribution. It starts by computing joint coverage 
of the naive unadjusted (point-wise) alpha-level  intervals, computed as percentiles across each order statistic (columns).
Alpha is decreased using a bisection search until the joint coverage becomes at least 100(1-alpha)\% depending on arguments
\code{max.iter} and \code{tol}. If the number of simulated random samples goes to infinity, the STB becomes exact.
Note that checking whether a numeric vector is normally distributed is equal to checking whether the residuals of the simplest
linear model y = mu + e (y~1) are normally distributed [e ~ N(0, sigma^2)].
}
\examples{
\dontrun{
set.seed(333)
mat <- t(apply(matrix(rnorm(10000*30), ncol=30), 1, sort))
stb.obj <- getSTB(mat, timer=TRUE)
stb.obj$cov
}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
\references{
Schuetzenmeister, A., Jensen, U., Piepho, H.P. (2011), Checking assumptions of normality and homoscedasticity in the general linear model. 
            Communications in Statistics - Simulation and Computation; S. 141-154
}
\seealso{
\link{fastSTB} \link{stb}
}

