#' Crab shells and anemones (3x3)
#' 
#' The placement of anemones on their shells by hermit crabs.
#' 
#' @docType data
#' 
#' @keywords datasets
#' 
#' @format A data frame with 9 rows and 3 columns:
#' \describe{
#'   \item{ShellColumn}{The column where anemone placed; one of \code{1} (Side 1), \code{2} (Central) or \code{3} (Side 2)}
#'   \item{ShellRow}{The row where anemone placed; one of \code{1} (Side 1), \code{2} (Central) or \code{3} (Side 2)}
#'   \item{Counts}{The number of anemones in the indicated sector on the shell}
#' }
#' 
#' @details
#' The data provide the number of anemones placed on their shell by 
#' hermit crabs in indicated regions.
#' Roughly, the shells are divided into a $3$ x $3$ grid of 
#' approximately equal areas.
#' 
#' @source 
#' Brooks, W. R. (1989). 
#' Hermit crabs alter sea anemone placement patterns for 
#' shell balance and reduced predation. 
#' \emph{Journal of Experimental Marine Biology and Ecology}, 
#' \bold{132}(2), 109--121.
#' 
#' @usage 
#' data(CrabShells3)
#' 
#' @examples
#' barplot( xtabs(Counts ~ ShellRow + ShellColumn, data = CrabShells3), names.arg = c("Column: Side 1", "Column: Central", "Column: Side 2"), ylab = "Number of anemones")


"CrabShells3"

