% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapParameters.R
\name{mapX2FLAGS}
\alias{mapX2FLAGS}
\title{Map x parameters to a list of named values}
\usage{
mapX2FLAGS(x, model = "dl")
}
\arguments{
\item{x}{matrix input values.}

\item{model}{(char) network type, e.g., \code{"cnn"} or \code{"dl"}. Default: \code{"dl"}}
}
\value{
FLAGS named list (parameter names as specified in \code{\link{getModelConf}}), e.g.,
  for "dl": dropout, dropoutfac, units, unitsfact, learning_rate,
  epochs, beta_1, beta_2, layers, epsilon, optimizer
}
\description{
numerical parameters are mapped to their meanings, e.g.,
\code{x[1]} to \code{"dropout rate"}.
}
\details{
For a \code{"dl"} network, the parameter vector \code{x} is mapped
to the following \code{FLAGS}:
\describe{
	\item{\code{x[1]: dropout}}{dropout rate first layer.}
	\item{\code{x[2]: dropoutfac}}{dropout factor (multiplier).}
	\item{\code{x[3]: units}}{number of units in the first layer.}
	\item{\code{x[4]: unitsfact}}{units factor (multiplier).}
	\item{\code{x[5]: learning_rate}}{learning rate for optimizer. See, e.g.: \code{link{optimizer_sgd}}}
	\item{\code{x[6]: epochs}}{number of training epochs.}
	\item{\code{x[7]: beta_1}}{The exponential decay rate for the 1st moment estimates. float, 0 < beta < 1. Generally close to 1.}
	\item{\code{x[8]: beta_2}}{The exponential decay rate for the 2nd moment estimates. float, 0 < beta < 1. Generally close to 1.}
	\item{\code{x[9]: layers}}{number of layers.}
 	\item{\code{x[10]: epsilon}}{float >= 0. Fuzz factor. If NULL, defaults to k_epsilon().}
 	\item{\code{x[11]: optimizer}}{integer. Specifies optimizer.}
}
}
\examples{
## First example: dense neural net
x <- getModelConf(list(model="dl"))$defaults
mapX2FLAGS(x=x, model = "dl")
## Second example: convnet
x <- getModelConf(list(model="cnn"))$defaults
mapX2FLAGS(x=x, model = "cnn")

}
