% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funContinuous.R
\name{funMeyer}
\alias{funMeyer}
\title{funMeyer}
\usage{
funMeyer(x)
}
\arguments{
\item{x}{matrix of points to evaluate with the function. 
Rows for points and columns for dimension.}
}
\value{
1-column matrix with resulting function values
}
\description{
Meyer Test Function
}
\examples{
x1 <- matrix(c(1,1,1),1,)
funMeyer(x1)

set.seed(13)
resMeyer <- spot(matrix(c(0.02,4000,250),1,3),
  funMeyer,c(0,1000,200),c(3,8000,500),
  control= list(funEvals=15))
resMeyer$xbest
resMeyer$ybest
print("Model with parameters")
plotModel(resMeyer$model)
plotModel(resMeyer$model,which=2:3)

}
\references{
More, J. J., Garbow, B. S., and Hillstrom, K. E. (1981).
Testing unconstrained optimization software.
\emph{ACM Transactions on Mathematical Software (TOMS)}, \emph{7}(1), 17-41.
\doi{10.1145/355934.355936}
}
