% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateKriging.R
\name{simulationDecompose}
\alias{simulationDecompose}
\title{Kriging Simulation: Decomposition}
\usage{
simulationDecompose(
  object,
  nsim = 1,
  xsim,
  conditionalSimulation = TRUE,
  returnAll = FALSE,
  ...
)
}
\arguments{
\item{object}{fit of the Kriging model (settings and parameters), of class \code{kriging}.}

\item{nsim}{number of simulations}

\item{xsim}{list of samples in input space, to be simulated}

\item{conditionalSimulation}{logical, if set to TRUE (default), the simulation is conditioned with the training data of the Kriging model.
Else, the simulation is non-conditional.}

\item{returnAll}{if set to TRUE, a list with the simulated values (y) and the corresponding covariance matrix (covar)
of the simulated samples is returned.}

\item{...}{further arguments, not used}
}
\value{
Returned value depends on the setting of \code{object$simulationReturnAll}
}
\description{
(Conditional) Simulation via decomposition approach.
}
\references{
N. A. Cressie. Statistics for Spatial Data. JOHN WILEY & SONS INC, 1993.

C. Lantuejoul. Geostatistical Simulation - Models and Algorithms. Springer-Verlag Berlin Heidelberg, 2002.
}
\seealso{
\code{\link{buildKriging}}, \code{\link{simulationSpectral}}
}
\keyword{internal}
