% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelMarkovChain.R
\name{modelMarkovChain}
\alias{modelMarkovChain}
\title{modelMarkovChain}
\usage{
modelMarkovChain(x, days, N, n = 3)
}
\arguments{
\item{x}{vector of three parameters. Used for parametrizing the MarkovChain model.
\describe{
    \item{\code{p}}{num  [0;1] proportion of confirmed cases}
    \item{\code{beta}}{num  A numeric vector with the transmission rate from susceptible to infected where each node can have 
    a different beta value. The vector must have length 1 or nrow(u0). 
    If the vector has length 1, but the model contains more nodes, 
    the beta value is repeated in all nodes.}
    \item{\code{gamma}}{num  A numeric vector with the recovery rate from infected to recovered where each node can have 
    a different gamma value. The vector must have length 1 or nrow(u0). 
    If the vector has length 1, but the model contains more nodes, the beta value is repeated in all nodes.}
    }}

\item{days}{number of simulation steps, usually days (int). 
It will be used to generate (internally) a vector (length >= 1) 
of increasing time points where the state of each node is to be returned.}

\item{N}{population size}

\item{n}{number of nodes to be evaluated in the \code{\link[SimInf]{SIR}} model}
}
\value{
data.frame of days obs. of 4 variables:
\describe{
	\item{\code{t}}{num  0 1 2 3 4 5 6 7 8 9 ... (timesteps)}
	\item{\code{X1}}{num  1704 1490 1275 1069 880 ... (susceptible)}
	\item{\code{X2}}{num  1000 1178 1351 1509 1646 ... (infected)}
	\item{\code{X3}}{num  num  0 36.3 78.5 126.2 178.8 ... (recovered)}		
}
}
\description{
Modeling continuous time Markov chains (MarkovChain) models using
\code{\link[SimInf]{SIR}} models.
}
\details{
SIR considers three compartments: S (susceptible), I (infected), and R (recovered).
Using the parameter vector x, the population size N, and the number of days 
(prediction horizon),  the SIR model parameters are determined as follows.
N denotes the population size. First: S, the number of susceptible in each node, 
will be calculated as N - I - R, where I is the number of infected in each node, and
R is the number of recovered in each node.
 Then, the data frame `u0` is set up:
\code{u0 = data.frame(S , I , R)}. 
`u0` contains the initial number of individuals in each compartment in every node. An integer matrix (Ncomp × Nnodes)
is used for storing `u0` information. 
The timespan is calculated as \code{tspan = 1:days}.
The \code{\link[SimInf]{SIR}} is set up and run, using \code{\link[SimInf]{run}}.
}
\examples{
\dontrun{
require("SimInf")
data <- preprocessInputData(regionTrain, regionPopulation)
regionData <- data[[1]]
N <- attr(regionData, "regionPopulation")
# N_curr <- max(regionData$confirmed)
p <- 0.01
beta <- 0.1
gamma <- 0.01
# parameter vector for the SIR model: (p, beta, gamma)
x <- c(p, beta, gamma)
# Every row in the data represents one day:
days <- nrow(regionData)
modelMarkovChain(x = x, days = days, N = N)
}
}
