% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing_helpers.R
\name{impute}
\alias{impute}
\alias{impute.somRes}
\title{Impute values from prototype information}
\usage{
impute(object, ...)
}
\arguments{
\item{object}{a \code{somRes} object.}

\item{...}{unused.}
}
\value{
Imputed matrix as in Cottrell and Letrémy, (2005)
}
\description{
Impute values by replacing missing entries with the 
corresponding assigned prototype entries
}
\examples{
# Run trainSOM algorithm on the iris data with 500 iterations
set.seed(1505)
missings <- cbind(sample(1:150, 50, replace = TRUE),
                  sample(1:4, 50, replace = TRUE))
x.data <- as.matrix(iris[, 1:4])
x.data[missings] <- NA
iris.som <- trainSOM(x.data = x.data)
iris.som
impute(iris.som)
}
\references{
Cottrell M., Letrémy P. (2005) Missing values: processing with the Kohonen 
algorithm. \emph{Proceedings of Applied Stochastic Models and Data Analysis
(ASMDA 2005)}, 489-496.
}
\seealso{
\code{\link{trainSOM}}
}
\author{
Nathalie Vialaneix \email{nathalie.vialaneix@inrae.fr}
}
