% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{coef.smle}
\alias{coef.smle}
\alias{coef.selection}
\title{Extract coefficients from fitted model}
\usage{
\method{coef}{smle}(object, ...)

\method{coef}{selection}(object, ...)
}
\arguments{
\item{object}{Returned fitted model object from either the function \code{SMLE} or \code{smle_select}.}

\item{...}{This argument is not used and listed for method consistency.}
}
\value{
Coefficients extracted from the fitted model object of class \code{'smle'} or class \code{'selection'}.
}
\description{
Extract coefficients from fitted model for either a \code{'smle'} or \code{'selection'} object.
}
\examples{

Data<-Gen_Data(n=100, p=5000, family = "gaussian", correlation="ID")
fit<-SMLE(Y=Data$Y, X=Data$X, k=9, family = "gaussian")
coef(fit)
}
\seealso{
SMLE
}
