% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlierLasso.R
\name{outlierLasso}
\alias{outlierLasso}
\title{Outliers LASSO}
\usage{
outlierLasso(
  zt,
  p = 12,
  crit = 3.5,
  family = "gaussian",
  standardize = TRUE,
  alpha = 1,
  jend = 3
)
}
\arguments{
\item{zt}{T by 1 vector of an observed scalar time series without missing values.}

\item{p}{Seasonal period. Default value is 12.}

\item{crit}{Criterion. Default is 3.5.}

\item{family}{Response type. See the glmnet command in R. Possible types are "gaussian", "binomial", "poisson",
"multinomial", "cox", "mgaussian". Default is "gaussian".}

\item{standardize}{Logical flag for zt variable standardization. See the glmnet command in R.
Default is TRUE.}

\item{alpha}{Elasticnet mixing parameter, with \eqn{0 \leq \alpha \leq 1}. See the glmnet command in R. Default value is 1.}

\item{jend}{Number of first and last observations assumed to not be level shift outliers.
Default value is 3.}
}
\value{
A list containing:
\itemize{
   \item nAO - Number of additive outliers.
   \item nLS - Number of level shifts.
}
}
\description{
Use LASSO estimation to identify outliers in a set of time series by creating dummy
variables for every time point.
}
\examples{
data(TaiwanAirBox032017)
output <- outlierLasso(TaiwanAirBox032017[1:100,1])

}
