% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_multi.R
\name{DA.multi}
\alias{DA.multi}
\title{Simultaneous estimation of Michaelis-Menten constant and catalytic constant
using the likelihood function with diffusion approximation method}
\usage{
DA.multi(method = T, dat, enz, subs, MM, catal, nrepeat = 10000,
  jump = 1, burning, catal_m_v = c(1, 10000), MM_m_v = c(1, 10000),
  sig, scale_tun = 80)
}
\arguments{
\item{method}{method selection: T=TQ model, F=SQ model(default = T)}

\item{dat}{observed dataset (time & trajectory columns)}

\item{enz}{enzyme concentrate}

\item{subs}{substrate concentrate}

\item{MM}{initial value of MM constant}

\item{catal}{initial value of catalytic constant}

\item{nrepeat}{total number of iteration (default=10000)}

\item{jump}{length of distance (default =1)}

\item{burning}{length of burning period (default =0)}

\item{catal_m_v}{catalytic prior gamma mean, variance(default=c(1,10000))}

\item{MM_m_v}{MM prior gamma mean, variance(default=c(1,10000))}

\item{sig}{variance of bivariate Normal proposal distribution}

\item{scale_tun}{scale tunning constant for stochastic simulation}
}
\value{
A n*2 matrix of postrior samples of catalytic constant and MM constant
}
\description{
The function estimates both catalytic constant and Michaelis-Menten constant
simultaneously using single data set with an initial enzyme concentrations
and substrate concentration. The diffusion approximation is utilized for the
likelihood function.
}
\details{
The function DA.multi generates a set of MCMC simulation samples from
the posterior distribution of catalytic constant and MM constant of enzyme
kinetics model. As the function estimates both two constants the user should
input the enzyme and substrate initial concentration. The prior information for
both two parameters can be given. The turning constant (scale_tun) and variances
for two constants (sig) can be set to controlled proper mixing and acceptance
ratio for updating two parameters simultaneously. The posterior samples are only
stored with fixed interval according to set "jump" to reduce serial correlation.
The initial iterations are removed for convergence. The “burning” is set the
length of initial iterations. The diffusion approximation method is used for
construction of the likelihood.
}
\examples{
\dontrun{
data('Chymo_low')
dou_DA=DA.multi(method=TRUE,dat=Chymo_low,enz=4.4e+7,subs=4.4e+7,MM=4.4e+8,catal=0.05
                ,nrepeat=10000,jump=1,burning=1,catal_m_v=c(1,1e+10),MM_m_v=c(1e+9,1e+18)
                ,sig=2.4*0.001*c(0.05,4.4e+8),scale_tun=80)
}

}
