% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{getAa}
\alias{getAa}
\alias{getQueenAa}
\alias{getFathersAa}
\alias{getVirginQueensAa}
\alias{getWorkersAa}
\alias{getDronesAa}
\title{Access epistasis values of individuals in a caste}
\usage{
getAa(x, caste = NULL, nInd = NULL, collapse = FALSE, simParamBee = NULL)

getQueenAa(x, collapse = FALSE, simParamBee = NULL)

getFathersAa(x, nInd = NULL, collapse = FALSE, simParamBee = NULL)

getVirginQueensAa(x, nInd = NULL, collapse = FALSE, simParamBee = NULL)

getWorkersAa(x, nInd = NULL, collapse = FALSE, simParamBee = NULL)

getDronesAa(x, nInd = NULL, collapse = FALSE, simParamBee = NULL)
}
\arguments{
\item{x}{\code{\link{Pop-class}}, \code{\link{Colony-class}}, or
\code{\link{MultiColony-class}}}

\item{caste}{NULL or character, NULL when \code{x} is a \code{\link{Pop-class}},
and character when \code{x} is a \code{\link{Colony-class}} or
 \code{\link{MultiColony-class}} with the possible values of "queen", "fathers",
 "workers", "drones", "virginQueens", or "all"}

\item{nInd}{numeric, number of individuals to access, if \code{NULL} all
individuals are accessed, otherwise a random sample}

\item{collapse}{logical, if the return value should be a single matrix
with epistatic values of all the individuals}

\item{simParamBee}{\code{\link{SimParamBee}}, global simulation parameters}
}
\value{
vector of epistasis values when \code{x} is
  \code{\link{Colony-class}} and list of vectors of epistasis values when
  \code{x} is \code{\link{MultiColony-class}}, named by colony id when \code{x}
  is \code{\link{MultiColony-class}}

# Not exporting this function, since the theory behind it is not fully developed
}
\description{
Level 0 function that returns epistasis values of
  individuals in a caste.
}
\section{Functions}{
\itemize{
\item \code{getQueenAa()}: Access epistasis value of the queen

\item \code{getFathersAa()}: Access epistasis values of fathers

\item \code{getVirginQueensAa()}: Access epistasis values of virgin queens

\item \code{getWorkersAa()}: Access epistasis values of workers

\item \code{getDronesAa()}: Access epistasis values of drones

}}
\seealso{
\code{\link{dd}} and
  \code{vignette(topic = "QuantitativeGenetics", package = "SIMplyBee")}
}
