fitdist <-
function(vals, probs, lower = -Inf, upper = Inf, weights = 1, tdf = 3){
	
	if(is.matrix(vals)==F){vals<-matrix(vals, nrow = length(vals), ncol = 1)}
	if(is.matrix(probs)==F){probs <- matrix(probs, nrow = nrow(vals), ncol = ncol(vals))}
	if(is.matrix(weights)==F){weights <- matrix(weights, nrow = nrow(vals), ncol = ncol(vals))}
	if(length(lower)==1){lower <- rep(lower, ncol(vals))}
	if(length(upper)==1){upper <- rep(upper, ncol(vals))}
	if(length(tdf)==1){tdf <- rep(tdf, ncol(vals))}
	
  
	
	n.experts <- ncol(vals)
	normal.parameters <- matrix(NA, n.experts, 2)
	t.parameters <- matrix(NA, n.experts, 3)
	gamma.parameters <- matrix(NA, n.experts, 2)
	lognormal.parameters <- matrix(NA, n.experts, 2)
	logt.parameters <- matrix(NA, n.experts, 3)
	beta.parameters <- matrix(NA, n.experts, 2)
	ssq<-matrix(NA, n.experts, 6)
	expertnames <- paste("expert.", 1:n.experts, sep="")
	
	limits <- data.frame(lower = lower, upper = upper)
	row.names(limits) <- expertnames
	
	for(i in 1:n.experts){
		if (min(probs[,i]) > 0.4 ){stop("smallest elicited probability must be less than 0.4")}
		if (min(probs[,i]) < 0 | max(probs[,i]) > 1 ){stop("probabilities must be between 0 and 1")}
		if (max(probs[,i]) < 0.6 ){stop("largest elicited probability must be greater than 0.6")}
    if (min(vals[,i]) < lower[i]){stop("elicited parameter values cannot be smaller than lower parameter limit")}
		if (max(vals[,i]) > upper[i]){stop("elicited parameter values cannot be greater than upper parameter limit")}
		if (tdf[i] <= 0 ){stop("Student-t degrees of freedom must be greater than 0")}
		if (min(probs[-1,i] - probs[-nrow(probs),i]) <= 0 ){stop("probabilities must be specified in ascending order")}
		if (min(vals[-1,i] - vals[-nrow(vals),i]) <= 0 ){stop("parameter values must be specified in ascending order")}
    
		
    q.fit <- approx(x = probs[,i], y = vals[,i], xout = c(0.4, 0.5, 0.6))$y
		l <- q.fit[1]
		m <- q.fit[2]
		u <- q.fit[3]
		v<-(u-l)^2 / 0.25 
	
		normal.fit <- optim(c(m, 0.5*log(v)), normal.error, values = vals[,i], probabilities = probs[,i], weights = weights[,i])   
    	normal.parameters[i,] <- c(normal.fit$par[1],exp(normal.fit$par[2]))
    	ssq[i,1] <- normal.fit$value
	
		t.fit <- optim(c(m, 0.5*log(v)), t.error, values = vals[,i], probabilities = probs[,i], weights = weights[,i], degreesfreedom = tdf[i])
    	t.parameters[i, 1:2] <- c(t.fit$par[1], exp(t.fit$par[2]))
    	t.parameters[i, 3] <- tdf[i]
    	ssq[i,2] <- t.fit$value
	
	
		if(lower[i] > -Inf){
			vals.scaled1 <- vals[,i] - lower[i]
			m.scaled1 <- m - lower[i]
		
			gamma.fit<-optim(c(log(m.scaled1^2/v), log(m.scaled1/v)), gamma.error, values = vals.scaled1, probabilities = probs[,i], weights = weights[,i])
    		gamma.parameters[i,] <- exp(gamma.fit$par)
    		ssq[i,3] <- gamma.fit$value
    		
    		std<-((log(u)-log(l))/1.35)
    	
    		lognormal.fit <- optim(c(log(m.scaled1), log(std)), lognormal.error, values = vals.scaled1, probabilities = probs[,i], weights = weights[,i])
    		lognormal.parameters[i, 1:2] <- c(lognormal.fit$par[1], exp(lognormal.fit$par[2]))
    		ssq[i,4] <- lognormal.fit$value
    	
    		logt.fit <- optim(c(log(m.scaled1), log(std)), logt.error, values = vals.scaled1, probabilities = probs[,i], weights = weights[,i], degreesfreedom = tdf[i])
    		logt.parameters[i,1:2] <- c(logt.fit$par[1], exp(logt.fit$par[2]))
    		logt.parameters[i,3] <- tdf[i]
    		ssq[i,5] <- logt.fit$value
		}
	
		if((lower[i] > -Inf) & (upper[i] < Inf)){
			vals.scaled2 <- (vals[,i] - lower[i]) / (upper[i] - lower[i])
			m.scaled2 <- (m - lower[i]) / (upper[i] - lower[i])
			v.scaled2 <- v / (upper[i] - lower[i])^2
		
			alp <- abs(m.scaled2 ^3 / v.scaled2 * (1/m.scaled2-1) - m.scaled2)
    		bet <- abs(alp/m.scaled2 - alp)
    		beta.fit <- optim(c(log(alp), log(bet)), beta.error, values = vals.scaled2, probabilities = probs[,i], weights = weights[,i])
    		beta.parameters[i,] <- exp(beta.fit$par)
    		ssq[i,6] <- beta.fit$value	
		
		}
	}
	dfn <- data.frame(normal.parameters)
	names(dfn) <-c ("mean", "sd")
	row.names(dfn) <- expertnames
		
	dft <- data.frame(t.parameters)
	names(dft) <-c ("location", "scale", "df")
	row.names(dft) <- expertnames
	
	dfg <- data.frame(gamma.parameters)
	names(dfg) <-c ("shape", "rate")
	row.names(dfg) <- expertnames
	
	dfln <- data.frame(lognormal.parameters)
	names(dfln) <-c ("mean.log.X", "sd.log.X")
	row.names(dfln) <- expertnames
	
	dflt <- data.frame(logt.parameters)
	names(dflt) <-c ("location.log.X", "scale.log.X", "df.log.X")
	row.names(dflt) <- expertnames
	
	dfb <- data.frame(beta.parameters)
	names(dfb) <-c ("shape1", "shape2")
	row.names(dfb) <- expertnames
	
	ssq <- data.frame(ssq)
	names(ssq) <- c("Normal", "Student-t", "Gamma", "Log normal", "Log Student-t", "Beta")
	row.names(ssq) <- expertnames
	
	index <- apply(ssq, 1, which.min)
	best.fitting <- data.frame(best.fit=names(ssq)[index])
	row.names(best.fitting) <- expertnames
  
	vals <- data.frame(vals)
	names(vals) <- expertnames
	
	probs <- data.frame(probs)
	names(probs) <- expertnames
		
  list(Normal = dfn, Student.t = dft, Gamma = dfg, Log.normal = dfln, Log.Student.t = dflt, Beta = dfb, ssq = ssq, best.fitting = best.fitting, vals = t(vals), probs = t(probs), limits = limits)
}
