% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SHAP_funcs.R
\name{shap.plot.force_plot}
\alias{shap.plot.force_plot}
\title{make the SHAP force plot.}
\usage{
shap.plot.force_plot(shapobs, id = "id", zoom_in_location = NULL,
  y_parent_limit = NULL, y_zoomin_limit = NULL, zoom_in = TRUE,
  zoom_in_group = NULL)
}
\arguments{
\item{shapobs}{The dataset obtained by \code{shap.prep.stack.data}.}

\item{id}{the id variable.}

\item{zoom_in_location}{where to zoom in, default at place of 60 percent of the data.}

\item{y_parent_limit}{set y axis limits.}

\item{y_zoomin_limit}{\code{c(a,b)} to limit the y-axis in zoom-in.}

\item{zoom_in}{default to TRUE, zoom in by \code{ggforce::facet_zoom}.}

\item{zoom_in_group}{optional to zoom in certain cluster.}
}
\description{
The force/stack plot, optional to zoom in at certain x or certain cluster.
}
\examples{

# **SHAP force plot**
plot_data <- shap.prep.stack.data(shap_contrib = shap_values_iris,
                                  n_groups = 4)
shap.plot.force_plot(plot_data)
shap.plot.force_plot(plot_data,  zoom_in_group = 2)

# plot all the clusters:
shap.plot.force_plot_bygroup(plot_data)
}
