% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lfhtcID.R
\name{lfhtcIdentifyStep}
\alias{lfhtcIdentifyStep}
\title{Perform one iteration of latent-factor HTC identification.}
\usage{
lfhtcIdentifyStep(
  graph,
  unsolvedParents,
  solvedParents,
  activeFroms,
  Zs,
  Ls,
  identifier,
  subsetSizeControl = Inf
)
}
\arguments{
\item{graph}{a \code{\link{LatentDigraph}} object representing
the latent-factor graph. All latent nodes in this graph should be
source nodes (i.e. have no parents).}

\item{unsolvedParents}{a list whose ith index is a vector of all the parents
j of i in the graph which for which the edge j->i is not yet known to be
generically identifiable.}

\item{solvedParents}{the complement of \code{unsolvedParents}, a list whose
ith index is a vector of all parents j of i for which the edge i->j
is known to be generically identifiable (perhaps by other algorithms).}

\item{activeFroms}{list. If node i is solved then the ith index is a vector
containing the nodes Y otherwise it is empty.}

\item{Zs}{list. If node i is solved then the ith index is a vector
containing the nodes Z otherwise it is empty.}

\item{Ls}{list. If node i is solved then the ith index is a vector
containing the nodes Z otherwise it is empty.}

\item{identifier}{an identification function that must produce the
identifications corresponding to those in solved parents. That is
\code{identifier} should be a function taking a single argument Sigma
(any generically generated covariance matrix corresponding
to the latent-factor graph) and returns a list with two named arguments}

\item{subsetSizeControl}{the largest subset of latent nodes to consider.}
}
\value{
a list with four components:
\describe{
  \item{\code{identifiedEdges}}{a matrix rx2 matrix where r is the number
  of edges that where identified by this function call and
  \code{identifiedEdges[i,1] -> identifiedEdges[i,2]} was the ith edge
  identified}
  \item{\code{unsolvedParents}}{as the input argument but updated with
  any newly identified edges}
  \item{\code{solvedParents}}{as the input argument but updated with
  any newly identified edges}
  \item{\code{identifier}}{as the input argument but updated with
  any newly identified edges}
  \item{\code{activeFroms}}{as the input argument but updated with
  any newly solved node}
  \item{\code{Zs}}{as the input argument but updated with
  any newly solved node}
  \item{\code{Ls}}{as the input argument but updated with
  any newly solved node}
}
}
\description{
A function that does one step through all the nodes in a latent-factor graph
and tries to identify new edge coefficients using the existence of
latent-factor half-trek systems.
}
\references{
Barber, R. F., Drton, M., Sturma, N., and Weihs L. (2022).
Half-Trek Criterion for Identifiability of Latent Variable Models.
\emph{arXiv preprint} arXiv:2201.04457
}
