% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htcID.R
\name{htcIdentifyStep}
\alias{htcIdentifyStep}
\title{Perform one iteration of HTC identification.}
\usage{
htcIdentifyStep(mixedGraph, unsolvedParents, solvedParents, identifier)
}
\arguments{
\item{mixedGraph}{a \code{\link{MixedGraph}} object representing
the mixed graph.}

\item{unsolvedParents}{a list whose ith index is a vector of all the parents
j of i in G which for which the edge j->i is not yet known to be
generically identifiable.}

\item{solvedParents}{the complement of \code{unsolvedParents}, a list whose
ith index is a vector of all parents j of i for which the edge i->j
is known to be generically identifiable (perhaps by other algorithms).}

\item{identifier}{an identification function that must produce the
       identifications corresponding to those in solved parents. That is
       \code{identifier} should be a function taking a single argument Sigma
       (any generically generated covariance matrix corresponding
       to the mixed graph) and returns a list with two named arguments
\describe{
  \item{Lambda}{denote the number of nodes in \code{mixedGraph} as n. Then
                Lambda is an nxn matrix whose i,jth entry
\enumerate{
  \item equals 0 if i is not a parent of j,
  \item equals NA if i is a parent of j but \code{identifier} cannot
        identify it generically,
  \item equals the (generically) unique value corresponding to the weight
        along the edge i->j that was used to produce Sigma.
}}
  \item{Omega}{just as Lambda but for the bidirected edges in the mixed
               graph}
}
       such that if j is in \code{solvedParents[[i]]} we must have that
       Lambda[j,i] is not NA.}
}
\value{
a list with four components:
\describe{
  \item{\code{identifiedEdges}}{a matrix rx2 matrix where r is the number
  of edges that where identified by this function call and
  \code{identifiedEdges[i,1] -> identifiedEdges[i,2]} was the ith edge
  identified}
  \item{\code{unsolvedParents}}{as the input argument but updated with
  any newly identified edges}
  \item{\code{solvedParents}}{as the input argument but updated with
  any newly identified edges}
  \item{\code{identifier}}{as the input argument but updated with
  any newly identified edges}
}
}
\description{
A function that does one step through all the nodes in a mixed graph
and tries to identify new edge coefficients using the existence of
half-trek systems as described in Foygel, Draisma, Drton (2012).
}
\references{
Foygel, R., Draisma, J., and Drton, M.  (2012) Half-trek criterion for
generic identifiability of linear structural equation models.
\emph{Ann. Statist.} 40(3): 1682-1713
}
