% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddfilter_loop.R
\name{ddfilter_loop}
\alias{ddfilter_loop}
\title{Filter locations by quality index, inner angle, and speed}
\usage{
ddfilter_loop(sdata, qi = 4, ia = 90, vmaxlp = 1.8)
}
\arguments{
\item{sdata}{A data frame containing columns with the following headers: "id", "DateTime", "lat", "lon", "qi". 
See the data \code{\link{turtle}} for an example.
The function filters the input data by a unique "id" (e.g. transmitter number, identifier for each animal). 
"DateTime" is the GMT date & time of each location in class \code{\link[base:DateTimeClasses]{POSIXct}} or \code{\link[base]{character}} with the following format "2012-06-03 01:33:46".
"lat" and "lon" are the latitude and longitude of each location in decimal degrees. 
"qi" is the quality index associated with each location fix. 
The input values can be either the number of GPS satellites or Argos Location Classes. 
Argos Location Classes will be converted to numerical values, where "A", "B", "Z" will be replaced with "-1", "-2", "-3" respectively.
The greater number indicates a higher accuracy.}

\item{qi}{An integer specifying a threshold of quality index, which is used to evaluate the locations of loop trips. 
Default is 4.}

\item{ia}{An integer specifying a threshold of inner angle, which is used to evaluate the locations of loop trips. 
Default is 90 degrees.}

\item{vmaxlp}{A numeric value specifying a threshold of speed, which is used to evaluate the locations of loop trips. 
Default is 1.8 km/h.
If this value is unknown, it can be estimated from \emph{sdata} using the function \code{\link{vmaxlp}}.}
}
\value{
The input data is returned without locations identified by this filter.
The following columns are added: "pTime", "sTime", "pDist", "sDist", "pSpeed", "sSpeed", "inAng".
"pTime" and "sTime" are hours from a previous and to a subsequent fix respectively.
"pDist" and "sDist" are straight distances in kilometres from a previous and to a subsequent fix respectively.
"pSpeed" and "sSpeed" are linear speed from a previous and to a subsequent fix respectively.
"inAng" is the degree between the bearings of lines joining successive location points.
}
\description{
A partial component of \code{\link{ddfilter}}, although works as a stand-alone function. 
This function removes locations by speed, inner angle, and quality index as described in Shimada et al. (2012).
}
\details{
This function removes locations if all of the following criteria apply: 
the number of source satellites are less than or equal to \emph{qi}, 
the inner angle is less than and equal to \emph{ia} and the speed either from a previous or to a subsequent location exceeds \emph{vmaxlp}. 
If \emph{vmaxlp} is unknown, it can be estimated using the function \code{\link{vmaxlp}}.
}
\references{
Shimada T, Jones R, Limpus C, Hamann M (2012) Improving data retention and home range estimates by data-driven screening. 
\emph{Marine Ecology Progress Series} 457:171-180 \doi{10.3354/meps09747}
}
\seealso{
\code{\link{ddfilter}}, \code{\link{ddfilter_speed}}, \code{\link{vmaxlp}}
}
\author{
Takahiro Shimada
}
