% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory_inference.R
\name{infer_trajectory}
\alias{infer_trajectory}
\title{Infer linear trajectory through space}
\usage{
infer_trajectory(
  space,
  k = 4,
  thresh = .001,
  maxit = 10,
  stretch = 0,
  smoother = "smooth.spline"
)
}
\arguments{
\item{space}{A numeric matrix or data frame containing the coordinates of samples.}

\item{k}{The number of clusters to cluster the data into.}

\item{thresh}{\code{\link[princurve]{principal.curve}} parameter: convergence threshhold on shortest distances to the curve}

\item{maxit}{\code{\link[princurve]{principal.curve}} parameter: maximum number of iterations}

\item{stretch}{\code{\link[princurve]{principal.curve}} parameter: a factor by which the curve can be extrapolated when points are projected}

\item{smoother}{\code{\link[princurve]{principal.curve}} parameter: choice of smoother}
}
\value{
A list containing several objects:
\itemize{
  \item \code{path}: the trajectory obtained by principal curves.
  \item \code{time}: the time point of each sample along the inferred trajectory.
}
}
\description{
\code{infer_trajectory} infers a trajectory through samples in a given space in a four-step process:
\enumerate{
  \item Perform \emph{k}-means clustering
  \item Calculate distance matrix between cluster centers using a custom distance function
  \item Find the shortest path connecting all cluster centers using the custom distance matrix
  \item Iteratively fit a curve to the given data using principal curves
}
}
\examples{
## Generate an example dataset and visualise it
dataset <- generate_dataset(type="poly", num_genes=500, num_samples=1000, num_groups=4)
dist <- correlation_distance(dataset$expression)
space <- reduce_dimensionality(dist, ndim=2)
draw_trajectory_plot(space, progression_group=dataset$sample_info$group_name)

## Infer a trajectory through this space
traj <- infer_trajectory(space)

## Visualise the trajectory
draw_trajectory_plot(space, path=traj$path, progression_group=dataset$sample_info$group_name)
}
\seealso{
\code{\link{reduce_dimensionality}}, \code{\link{draw_trajectory_plot}}
}
