% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{SCIBER}
\alias{SCIBER}
\title{Batch effect removal with SCIBER}
\usage{
SCIBER(
  input_batches,
  ref_index = NULL,
  batches_meta_data = NULL,
  omega = 0.5,
  alpha = 0.05,
  h_fisher = 75,
  n_core = parallel::detectCores(),
  seed = 7,
  k = NULL
)
}
\arguments{
\item{input_batches}{A list contains all the pre-processed matrices with dimension of n_genes*n_cells.}

\item{ref_index}{The index of the reference batch in the object "input_batches"}

\item{batches_meta_data}{A list contains the meta data for all the batches. The order should be consistent with that in "input_batches". Each meta data contains three columns, "cell_id", "cell_type", and "dataset". "dataset" indicates which batch the data comes from. The row names of meta data should match the column names of batch.}

\item{omega}{A list of proportion of matched clusters or a single value between 0 and 1 applied to all query batches.}

\item{alpha}{The significance level for all clusters to choose the number of matched clusters. The default is 0.05.}

\item{h_fisher}{The number of marker genes used for Fisher exact test.}

\item{n_core}{Specify the number of cores otherwise use all the available cores.}

\item{seed}{random seed.}

\item{k}{Number of clusters used for K-means. If not provided, the default is k = the square root of n_0, where n_0 is the number of cells in the reference batch.}
}
\value{
A list which contains the reference and batch-effect-corrected batches. The order is the same as that in input_batches.
}
\description{
Batch effect removal with SCIBER
}
\examples{
data(HumanDC)
exp <- HumanDC[["exp"]]
meta <- HumanDC[["metadata"]]
omega <- c()
omega[[1]] <- 0.5
res <- SCIBER(input_batches = exp, ref_index = 1,
batches_meta_data = meta, omega = omega, n_core = 1)
}
