% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edges.R
\name{dedges.sbm}
\alias{dedges.sbm}
\title{Density of edges}
\usage{
\method{dedges}{sbm}(x, edges, edgemod, na.rm = TRUE, ...)
}
\arguments{
\item{x}{an \code{\link{sbm}} object}

\item{edges}{an \code{\link{edges}} object}

\item{edgemod}{an \code{\link{edgemod}} object}

\item{na.rm}{remove NAs when calculating?}

\item{...}{additional arguments for \code{dedges.params}}
}
\value{
matrix same size as \code{edges$E} with density of each edge
}
\description{
Compute the probability density for an \code{\link{edges}} object under an \code{\link{sbm}} object
}
\examples{
## make an sbm model, sample data then plot and print:
model <- sbmmod(dma(2,5), param_beta(1,1,1,1), edges_bern())
s <- model$r(100)
e <- redges(s, model$edge)
dedges(s, e, model$edge)
}
