% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bc.QM.R
\name{QM}
\alias{QM}
\title{Quantile Mapping method}
\description{
Perform an univariate bias correction of X0 with respect to Y0
}
\details{
Correction is applied margins by margins.
}
\examples{
## Three bivariate random variables (rnorm and rexp are inverted between ref
## and bias)
XY = SBCK::dataset_gaussian_exp_2d(2000)
X0 = XY$X0 ## Biased in calibration period
Y0 = XY$Y0 ## Reference in calibration period

## Bias correction
## Step 1 : construction of the class QM 
qm = SBCK::QM$new() 
## Step 2 : Fit the bias correction model
qm$fit( Y0 , X0 )
## Step 3 : perform the bias correction, Z0 is the correction of
## X0 with respect to the estimation of Y0
Z0 = qm$predict(X0)

# ## But in fact the laws are known, we can fit parameters:
distY0 = list( ROOPSD::Exponential , ROOPSD::Normal )
distX0 = list( ROOPSD::Normal , ROOPSD::Exponential )
qm_fix = SBCK::QM$new( distY0 = distY0 , distX0 = distX0 )
qm_fix$fit( Y0 , X0 )
Z0 = qm_fix$predict(X0) 
}
\references{
Panofsky, H. A. and Brier, G. W.: Some applications of statistics
            to meteorology, Mineral Industries Extension Services, College of
            Mineral Industries, Pennsylvania State University, 103 pp., 1958.

Wood, A. W., Leung, L. R., Sridhar, V., and Lettenmaier, D. P.:
            Hydrologic Implications of Dynamical and Statistical Approaches
            to Downscaling Climate Model Outputs, Clim. Change, 62, 189–216,
            https://doi.org/10.1023/B:CLIM.0000013685.99609.9e, 2004.

Déqué, M.: Frequency of precipitation and temperature extremes
            over France in an anthropogenic scenario: Model results and
            statistical correction according to observed values, Global
            Planet. Change, 57, 16–26,
            https://doi.org/10.1016/j.gloplacha.2006.11.030, 2007.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{distX0}}{[ROOPSD distribution or a list of them] Describe the law of
each margins. A list permit to use different laws for each
margins. Default is ROOPSD::rv_histogram.}

\item{\code{distY0}}{[ROOPSD distribution or a list of them] Describe the law of
each margins. A list permit to use different laws for each
margins. Default is ROOPSD::rv_histogram.}

\item{\code{n_features}}{[integer] Numbers of features}

\item{\code{tol}}{[double] Floatting point tolerance}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-QM-new}{\code{QM$new()}}
\item \href{#method-QM-fit}{\code{QM$fit()}}
\item \href{#method-QM-predict}{\code{QM$predict()}}
\item \href{#method-QM-clone}{\code{QM$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QM-new"></a>}}
\if{latex}{\out{\hypertarget{method-QM-new}{}}}
\subsection{Method \code{new()}}{
Create a new QM object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QM$new(distX0 = ROOPSD::rv_histogram, distY0 = ROOPSD::rv_histogram, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{distX0}}{[ROOPSD distribution or a list of them] Describe the law of
model}

\item{\code{distY0}}{[ROOPSD distribution or a list of them] Describe the law of
observations}

\item{\code{...}}{[] kwargsX0 or kwargsY0, arguments passed to distX0 and distY0}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `QM` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QM-fit"></a>}}
\if{latex}{\out{\hypertarget{method-QM-fit}{}}}
\subsection{Method \code{fit()}}{
Fit the bias correction method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QM$fit(Y0 = NULL, X0 = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Y0}}{[matrix: n_samples * n_features] Observations in calibration}

\item{\code{X0}}{[matrix: n_samples * n_features] Model in calibration}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QM-predict"></a>}}
\if{latex}{\out{\hypertarget{method-QM-predict}{}}}
\subsection{Method \code{predict()}}{
Predict the correction
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QM$predict(X0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X0}}{[matrix: n_samples * n_features or NULL] Model in calibration}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[matrix] Return the corrections of X0
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QM-clone"></a>}}
\if{latex}{\out{\hypertarget{method-QM-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QM$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
