% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/defaultSAC.R
\name{defaultSAC}
\alias{defaultSAC}
\title{Default settings for the SACOBRA part of COBRA.}
\usage{
defaultSAC(DOSAC = 1)
}
\arguments{
\item{DOSAC}{[0|1|2] 0: COBRA-R settings (turn off SACOBRA), 1: SACOBRA settings, 2: SACOBRA settings
               with fewer parameters and more online adujustement (aFF and aCF are done parameter free).}
}
\value{
a list with the following elements (the values in parantheses \code{[|]} are the values
   for \code{DOSAC=[0|1|2]}):
   \describe{
     \item{RS}{  flag for random start algorithm \code{[FALSE|TRUE|TRUE]}  }
     \item{RStype}{type of the function to calculate probability to start the internal optimizer
                 with a random starting point\code{[NA|SIGMOID|CONSTANT]} (see function
                 \code{RandomStart} in \code{SACOBRA.R})}
     \item{RSmax}{maximum probability of a random start when RStype is selected as SIGMOID (see \code{RandomStart} in \code{SACOBRA.R})
     if RStype is CONSTANT then random start is done with a constant probability determined from mean(c(RSmax,RSmin)) \code{[NA|0.3|0.3]}}
     \item{RSmin}{manimum probability of a random start when RStype is selected as SIGMOID (see \code{RandomStart} in \code{SACOBRA.R})\code{[NA|0.05|0.05]} }
     \item{aDRC}{  flag for automatic DRC adjustment \code{[FALSE|TRUE|TRUE]}  }
     \item{aFF}{  flag for automatic objective function transformation \code{[FALSE|TRUE|TRUE]}  }
     \item{aCF}{  flag for automatic constraint function transformation \code{[FALSE|TRUE|TRUE]}  }
     \item{TFRange}{  threshold, if \code{FRange} is larger, then apply automatic objective
         function transformation (see \code{\link{plog}}). \code{[Inf|1e+05|-1]}  }
     \item{TGR}{  threshold, if \code{GRatio} is larger, then apply automatic constraint
         function transformation. \code{GRatio} is the ratio "largest \code{GRange} /
         smallest \code{GRange}" where \code{GRange} is the min-max range of a specific constraint.
         If \code{TGR < 1}, then the transformation is always performed.  \code{[Inf|1e+03|-1]}.}
     \item{CS}{  threshold unsuccessful iterations for random start algorithm. If  \code{CS}
         iterations in a row do not improve the ever-best feasible solution, then perform a
         restart. \code{[10|10|10]}  }
     \item{adaptivePLOG}{  (experimental) flag for objective function transformation with \code{\link{plog}},
         where the parameter \code{pShift} is adapted during iterations.
         \code{[FALSE|FALSE|FALSE]} }
     \item{onlinePLOG}{ flag for online decision making wether use plog or not according to p-effect \code{\link{plog}}.
         \code{[FALSE|FALSE|TRUE]} }
     \item{pEffectInit}{Initial pEffect value when using onlinePLOG. If pEffectInit >= 2 then the initial model is built after plog transformation.
         \code{[NA|NA|2]}}
   }
}
\description{
Sets suitable defaults for the SACOBRA part of COBRA. \cr
With the call \code{\link{setOpts}(mySAC,defaultSAC())} it is possible to extend a partial list
\code{mySAC} to a list containing all \code{sac}-elements (the missing ones are taken from
\code{defaultSAC()}).
}
\details{
For backward compatibility, a logical DOSAC (deprecated) is mapped from FALSE to 0 and
from TRUE to 1.
}
\author{
Samineh Bagheri, Cologne Univeristy of Applied Sciences
}
\seealso{
\code{\link{cobraInit}}, \code{\link{cobraPhaseII}}
}

