% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RxODE.R
\name{rxTrans}
\alias{rxTrans}
\alias{rxTrans.default}
\alias{rxTrans.character}
\title{Translate the model to C code if needed}
\usage{
rxTrans(
  model,
  extraC = NULL,
  modelPrefix = "",
  md5 = "",
  modName = NULL,
  modVars = FALSE,
  ...
)

\method{rxTrans}{default}(
  model,
  extraC = NULL,
  modelPrefix = "",
  md5 = "",
  modName = NULL,
  modVars = FALSE,
  ...
)

\method{rxTrans}{character}(
  model,
  extraC = NULL,
  modelPrefix = "",
  md5 = "",
  modName = NULL,
  modVars = FALSE,
  ...
)
}
\arguments{
\item{model}{This is the ODE model specification.  It can be:

\itemize{

 \item a string containing the set of ordinary differential
    equations (ODE) and other expressions defining the changes in
    the dynamic system.

 \item a file name where the ODE system equation is contained

 \item An ODE expression enclosed in \code{\{\}}

  }

(see also the \code{filename} argument). For
    details, see the sections \dQuote{Details} and
    \dQuote{\code{RxODE Syntax}} below.}

\item{extraC}{Extra c code to include in the model.  This can be
useful to specify functions in the model.  These C functions
should usually take \code{double} precision arguments, and
return \code{double} precision values.}

\item{modelPrefix}{Prefix of the model functions that will be
compiled to make sure that multiple RxODE objects can coexist
in the same R session.}

\item{md5}{Is the md5 of the model before parsing, and is used to
embed the md5 into DLL, and then provide for functions like
\code{\link{rxModelVars}}.}

\item{modName}{a string to be used as the model name. This string
is used for naming various aspects of the computations,
including generating C symbol names, dynamic libraries,
etc. Therefore, it is necessary that \code{modName} consists of
simple ASCII alphanumeric characters starting with a letter.}

\item{modVars}{returns the model variables instead of the named
vector of translated properties.}

\item{...}{Ignored parameters.}
}
\value{
a named vector of translated model properties
      including what type of jacobian is specified, the \code{C} function prefixes,
      as well as the \code{C} functions names to be called through the compiled model.
}
\description{
This function translates the model to C code, if needed
}
\seealso{
\code{\link{RxODE}}, \code{\link{rxCompile}}.
}
\author{
Matthew L.Fidler
}
