% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcgClostKD.r
\name{vcgClostKD}
\alias{vcgClostKD}
\title{Project coordinates onto a target triangular surface mesh using KD-tree search}
\usage{
vcgClostKD(x, mesh, sign = TRUE, barycentric = FALSE,
  smoothNormals = FALSE, borderchk = FALSE, k = 50, nofPoints = 16,
  maxDepth = 64, angdev = NULL, weightnorm = FALSE,
  facenormals = FALSE, threads = 1, ...)
}
\arguments{
\item{x}{k x 3 matrix containing 3D-coordinates or object of class "mesh3d".}

\item{mesh}{triangular surface mesh stored as object of class "mesh3d".}

\item{sign}{logical: if TRUE, signed distances are returned.}

\item{barycentric}{logical: if TRUE, barycentric coordinates of the hit
points are returned.}

\item{smoothNormals}{logical: if TRUE, laplacian smoothed normals are used.}

\item{borderchk}{logical: request checking if the hit face is at the border of the mesh.}

\item{k}{integer: check the kdtree for the\code{k} closest faces (using faces' barycenters.}

\item{nofPoints}{integer: number of points per cell in the kd-tree (don't change unless you know what you are doing!)}

\item{maxDepth}{integer: depth of the kd-tree (don't change unless you know what you are doing!)}

\item{angdev}{maximum deviation between reference and target normals. If the none of the k closest triangles match this criterion, the closest point on the closest triangle is returned but the corresponding distance in $quality is set to 1e5.}

\item{weightnorm}{logical if angdev is set, this requests the normal of the closest points to be estimated by weighting the surrounding vertex normals. Otherwise, simply the hit face's normal is used (faster but slightly less accurate)}

\item{facenormals}{logical: if TRUE only the facenormal of the face the closest point has hit is returned, the weighted average of the surrounding vertex normals otherwise.}

\item{threads}{integer: threads to use in closest point search.}

\item{...}{additional parameters, currently unused.}
}
\value{
returns an object of class "mesh3d" with:
\item{vb }{4 x n matrix containing n vertices as homolougous coordinates.}
\item{normals }{4 x n matrix containing vertex normals.}
\item{quality }{numeric vector containing distances to target.}
\item{it }{3 x m integer matrix containing vertex indices forming triangular
faces.Only available, when x is a mesh.}
\item{border }{integer vector of length n: if borderchk = TRUE, for each clostest point the value will be 1 if the hit face is at the border of the target mesh and 0 otherwise.} 
\item{barycoords }{3 x m Matrix containing barycentric coordinates of
closest points; only available if barycentric=TRUE.}
}
\description{
For a set of 3D-coordinates/triangular mesh, the closest matches on a
target surface are determined (by using KD-tree search) and normals at as well as distances to
that point are calculated.
}
\note{
Other than \code{vcgClost} this does not search a grid, but first uses a KD-tree search to find the \code{k} closest barycenters for each point and then searches these faces for the closest match.
}
\references{
Baerentzen, Jakob Andreas. & Aanaes, H., 2002. Generating Signed
Distance Fields From Triangle Meshes. Informatics and Mathematical
Modelling.
}
\seealso{
\code{\link{vcgPlyRead}}
}
\author{
Stefan Schlager
}
