% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/vcgBorder.r
\name{vcgBorder}
\alias{vcgBorder}
\title{find all border vertices and faces of a triangular mesh}
\usage{
vcgBorder(mesh)
}
\arguments{
\item{mesh}{triangular mesh of class "mesh3d"}
}
\value{
\item{bordervb}{logical: vector containing boolean value for each vertex, if it is a border vertex.}
\item{borderit}{logical: vector containing boolean value for each face, if it is a border vertex.}
}
\description{
Detect faces and vertices at the borders of a mesh and mark them.
}
\examples{
data(humface)
borders <- vcgBorder(humface)
## view border vertices
\dontrun{
require(rgl)
points3d(t(humface$vb[1:3,])[which(borders$bordervb == 1),],col=2)
wire3d(humface)
require(rgl)
}
}
\author{
Stefan Schlager
}
\seealso{
\code{\link{vcgPlyRead}}
}
\keyword{~kwd1}
\keyword{~kwd2}

