% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify_track_format.R
\name{identify_track_format}
\alias{identify_track_format}
\title{Check the format of a track file.}
\usage{
identify_track_format(filename = NULL)
}
\arguments{
\item{filename}{A raw data file containing path coordinates. If this is NULL or
missing, then a message is given listing all of the possible format codes.}
}
\value{
The format code as a character string. This code can be used as the
  \code{track.format} parameter for \code{\link{read_path}} or in the
  \code{_TrackFileFormat} column in the experiment description passed to
  \code{\link{read_experiment}}.

  If the track format cannot be determined, \code{NA} is returned.
}
\description{
A helper utility to determine the raw data format.
}
\details{
Raw data from several sources can be read in directly. A number of formats are
supported, but it might not be clear which format code corresponds to your data. This
function can be run on a typical file to try to guess your file format. If the format
is not recognised, please visit the help page at
\url{http://rupertoverall.net/Rtrack/help.html} where it is also possible to request
support for new formats.
}
\examples{
require(Rtrack)
track_file = system.file("extdata", "Track_1.csv", package = "Rtrack")
identify_track_format(track_file)

}
\seealso{
\code{\link{read_path}}, or \code{\link{read_experiment}} to read the track
  files.
}
