create_function <- function(lib, tool) {
  # Function generate text that will be parsed into R code
  #
  # Internal variable `args` is derived by capturing the names and values of the
  # calling function.
  # 
  # senv is the SAGA-GIS library settings (generated by `saga_env`) and comes
  # from the environment of when the dynamic function was generated.
  #
  # Arguments
  # lib : Name of SAGA-GIS library.
  # tool : Name of SAGA-GIS tool.
  #
  # Returns
  # A character.
  
  paste(
    paste0("args = as.list(environment())"),
    paste0("lib = ", deparse(lib)),
    paste0("tool = ", deparse(tool)),
    "
        # remove intern and help from saga args list
        if ('.intern' %in% names(args))
            args = args[-which(names(args) == '.intern')]
        
        if ('.all_outputs' %in% names(args))
            args = args[-which(names(args) == '.all_outputs')]
        
        # call the saga geoprocessor
        saga_results = saga_execute(lib, tool, senv, .intern, .all_outputs, args)
        return (saga_results)
        ",
    sep = "\n"
  )
}
