% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_wav_case.R
\name{match_wav_case}
\alias{match_wav_case}
\title{Fix the extension case of sound files}
\usage{
match_wav_case(X, path = NULL, output = "data.frame", verbose = TRUE)
}
\arguments{
\item{X}{Data frame containing columns for sound file (sound.files) and selection
(selec). See example data 'selec.table' in the \code{\link{warbleR}}) package.}

\item{path}{A character string indicating the path of the directory in which to look for sound files. 
If not provided (default) the function searches into the current working directory.}

\item{output}{Character string. Controls whether a complete data frame ('data.frame') 
or only the sound file names ("names") are returned. Default is 'data.frame'.}

\item{verbose}{Logical to control if messages are printed (\code{TRUE}, default).}
}
\value{
The same data as in the input data frame but with the case of the extension file names in the 'sound.files' column matching those of the sound files themselves.
}
\description{
\code{match_wav_case} fixes the extension case of sound files in a selection table.
}
\details{
The function returns the data from the input data frame with extension file
names in the 'sound.files' column matching those of the sound files (in case there was
any mismatch). The function needs the path to the sound files to compare extension names.
}
\examples{
library(warbleR)
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4", 
"selec.table"))

writeWave(Phae.long1, "Phae.long1.wav", extensible = FALSE) #save sound files 
writeWave(Phae.long2, "Phae.long2.wav", extensible = FALSE)
writeWave(Phae.long3, "Phae.long3.wav", extensible = FALSE)
writeWave(Phae.long4, "Phae.long4.wav", extensible = FALSE)

# change one extension
selec.table$sound.files <- as.character(selec.table$sound.files)
selec.table$sound.files[1] <- gsub("\\\\.wav$", ".WAV", selec.table$sound.files[1]) 
 
 # fixed extension an return data frame
 match_wav_case(X = selec.table)
  
 # fixed extension an return sound file names
 match_wav_case(X = selec.table, output = "names")
    
}
\seealso{
\code{\link{relabel_colms}}
}
\author{
Marcelo Araya-Salas (\email{marceloa27@gmail.com})
}
