% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.RprobitB_data}
\alias{plot.RprobitB_data}
\title{Visualize choice data}
\usage{
\method{plot}{RprobitB_data}(x, by_choice = FALSE, alpha = 1, position = "dodge", ...)
}
\arguments{
\item{x}{An object of class \code{RprobitB_data}.}

\item{by_choice}{Set to \code{TRUE} to group the covariates by the chosen alternatives.}

\item{alpha, position}{Passed to \code{\link[ggplot2]{ggplot}}.}

\item{...}{Ignored.}
}
\value{
No return value. Draws a plot to the current device.
}
\description{
This function is the plot method for an object of class \code{RprobitB_data}.
}
\examples{
data <- simulate_choices(
 form = choice ~ cost | 0,
 N = 100,
 T = 10,
 J = 2,
 alternatives = c("bus", "car"),
 true_parameter = list("alpha" = -1)
)
plot(data, by_choice = TRUE)
}
