% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_evaluation.R
\name{choice_probabilities}
\alias{choice_probabilities}
\title{Compute choice probabilities}
\usage{
choice_probabilities(x, data = NULL, par_set = mean)
}
\arguments{
\item{x}{An object of class \code{RprobitB_fit}.}

\item{data}{Either \code{NULL} or an object of class \code{RprobitB_data}. In the former
case, choice probabilities are computed for the data that was used for model
fitting. Alternatively, a new data set can be provided.}

\item{par_set}{Specifying the parameter set for calculation and either
\itemize{
\item a function that computes a posterior point estimate (the default is
\code{mean()}),
\item \code{"true"} to select the true parameter set,
\item an object of class \code{RprobitB_parameter}.
}}
}
\value{
A data frame of choice probabilities with choice situations in rows and
alternatives in columns. The first two columns are the decider identifier
\code{"id"} and the choice situation identifier \code{"idc"}.
}
\description{
This function returns the choice probabilities of an \code{RprobitB_fit}
object.
}
\examples{
data <- simulate_choices(form = choice ~ covariate, N = 10, T = 10, J = 2)
x <- fit_model(data)
choice_probabilities(x)

}
