% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_fitting.R
\name{RprobitB_latent_classes}
\alias{RprobitB_latent_classes}
\title{Create object of class \code{RprobitB_latent_classes}}
\usage{
RprobitB_latent_classes(latent_classes = NULL)
}
\arguments{
\item{latent_classes}{Either \code{NULL} (for no latent classes) or a list of parameters specifying
the number of latent classes and their updating scheme:
\itemize{
\item \code{C}: The fixed number (greater or equal 1) of latent classes,
which is set to 1 per default. If either \code{weight_update = TRUE}
or \code{dp_update = TRUE} (i.e. if classes are updated), \code{C}
equals the initial number of latent classes.
\item \code{weight_update}: A boolean, set to \code{TRUE} to weight-based
update the latent classes. See ... for details.
\item \code{dp_update}: A boolean, set to \code{TRUE} to update the latent
classes based on a Dirichlet process. See ... for details.
\item \code{Cmax}: The maximum number of latent classes.
\item \code{buffer}: The number of iterations to wait before a next
weight-based update of the latent classes.
\item \code{epsmin}: The threshold weight (between 0 and 1) for removing
a latent class in the weight-based updating scheme.
\item \code{epsmax}: The threshold weight (between 0 and 1) for splitting
a latent class in the weight-based updating scheme.
\item \code{distmin}: The (non-negative) threshold in class mean difference
for joining two latent classes in the weight-based updating scheme.
}}
}
\value{
An object of class \code{RprobitB_latent_classes}.
}
\description{
This function creates an object of class \code{RprobitB_latent_classes} which
defines the number of latent classes and their updating scheme.
The \code{RprobitB_latent_classes} object generated
by this function is only of relevance if the model possesses at least one
random coefficient, i.e. if \code{P_r>0}.
}
\details{
\subsection{Why update latent classes?}{

In order not to have to specify the number of latent classes before
estimation.
}

\subsection{What options to update latent classes exist?}{

Currently two updating schemes are implemented, weight-based and
via a Dirichlet process, see
\href{https://loelschlaeger.de/RprobitB/articles/v04_modeling_heterogeneity.html}{the vignette on modeling heterogeneity}.
}

\subsection{What is the default behavior?}{

One latent class without updates is specified per default. Print an
\code{RprobitB_latent_classes}-object to see a summary of all relevant
(default) parameter settings.
}

\subsection{Why is \code{Cmax} required?}{

The implementation requires an upper bound on the number of latent classes
for saving the Gibbs samples. However, this is not a restriction since the
number of latent classes is bounded by the number of deciders in any case.
A plot method for visualizing the sequence of class numbers after estimation
and can be used to check if \code{Cmax} was reached, see
\code{\link{plot.RprobitB_fit}}.
}
}
\examples{
### default setting
RprobitB:::RprobitB_latent_classes()

### setting for a fixed number of two latent classes
RprobitB:::RprobitB_latent_classes(list(C = 2))

### setting for weight-based on Dirichlet process-based updates
RprobitB:::RprobitB_latent_classes(
  list("weight_update" = TRUE, "dp_update" = TRUE)
)

}
\keyword{internal}
