% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_fitting.R
\name{update.RprobitB_fit}
\alias{update.RprobitB_fit}
\title{Update and re-fit probit model}
\usage{
\method{update}{RprobitB_fit}(
  object,
  form,
  re,
  alternatives,
  id,
  idc,
  standardize,
  impute,
  scale,
  R,
  B,
  Q,
  print_progress,
  prior,
  latent_classes,
  seed,
  ...
)
}
\arguments{
\item{object}{An object of class \code{RprobitB_fit}.}

\item{form}{A \code{formula} object that is used to specify the model equation.
The structure is \code{choice ~ A | B | C}, where
\itemize{
\item \code{choice} is the name of the dependent variable (the choices),
\item \code{A} are names of alternative and choice situation specific
covariates with a coefficient that is constant across alternatives,
\item \code{B} are names of choice situation specific covariates with
alternative specific coefficients,
\item and \code{C} are names of alternative and choice situation specific
covariates with alternative specific coefficients.
}

Multiple covariates (of one type) are separated by a \code{+} sign.
By default, alternative specific constants (ASCs) are added to the model.
They can be removed by adding \code{+0} in the second spot.

In the ordered probit model (\code{ordered = TRUE}), the \code{formula}
object has the simple structure \code{choice ~ A}. ASCs are not estimated.}

\item{re}{A character (vector) of covariates of \code{form} with random effects.
If \code{re = NULL} (the default), there are no random effects.
To have random effects for the ASCs, include \code{"ASC"} in \code{re}.}

\item{alternatives}{A character vector with the names of the choice alternatives.
If not specified, the choice set is defined by the observed choices.
If \code{ordered = TRUE}, \code{alternatives} is assumed to be specified with
the alternatives ordered from worst to best.}

\item{id}{A character, the name of the column in \code{choice_data} that contains
unique identifier for each decision maker. The default is \code{"id"}.}

\item{idc}{A character, the name of the column in \code{choice_data} that contains
unique identifier for each choice situation of each decision maker.
Per default, these identifier are generated by the order of appearance.}

\item{standardize}{A character vector of names of covariates that get standardized.
Covariates of type 1 or 3 have to be addressed by
\code{<covariate>_<alternative>}.
If \code{standardize = "all"}, all covariates get standardized.}

\item{impute}{A character that specifies how to handle missing covariate entries in
\code{choice_data}, one of:
\itemize{
\item \code{"complete_cases"}, removes all rows containing missing
covariate entries (the default),
\item \code{"zero"}, replaces missing covariate entries by zero
(only for numeric columns),
\item \code{"mean"}, imputes missing covariate entries by the mean
(only for numeric columns).
}}

\item{scale}{A character which determines the utility scale. It is of the form
\verb{<parameter> := <value>}, where \verb{<parameter>} is either the name of a fixed
effect or \verb{Sigma_<j>,<j>} for the \verb{<j>}th diagonal element of \code{Sigma}, and
\verb{<value>} is the value of the fixed parameter.}

\item{R}{The number of iterations of the Gibbs sampler.}

\item{B}{The length of the burn-in period, i.e. a non-negative number of samples to
be discarded.}

\item{Q}{The thinning factor for the Gibbs samples, i.e. only every \code{Q}th
sample is kept.}

\item{print_progress}{A boolean, determining whether to print the Gibbs sampler progress and the
estimated remaining computation time.}

\item{prior}{A named list of parameters for the prior distributions. See the documentation
of \code{\link{check_prior}} for details about which parameters can be
specified.}

\item{latent_classes}{Either \code{NULL} (for no latent classes) or a list of parameters specifying
the number of latent classes and their updating scheme:
\itemize{
\item \code{C}: The fixed number (greater or equal 1) of latent classes,
which is set to 1 per default. If either \code{weight_update = TRUE}
or \code{dp_update = TRUE} (i.e. if classes are updated), \code{C}
equals the initial number of latent classes.
\item \code{weight_update}: A boolean, set to \code{TRUE} to weight-based
update the latent classes. See ... for details.
\item \code{dp_update}: A boolean, set to \code{TRUE} to update the latent
classes based on a Dirichlet process. See ... for details.
\item \code{Cmax}: The maximum number of latent classes.
\item \code{buffer}: The number of iterations to wait before a next
weight-based update of the latent classes.
\item \code{epsmin}: The threshold weight (between 0 and 1) for removing
a latent class in the weight-based updating scheme.
\item \code{epsmax}: The threshold weight (between 0 and 1) for splitting
a latent class in the weight-based updating scheme.
\item \code{distmin}: The (non-negative) threshold in class mean difference
for joining two latent classes in the weight-based updating scheme.
}}

\item{seed}{Set a seed for the Gibbs sampling.}

\item{...}{Ignored.}
}
\value{
An object of class \code{RprobitB_fit}.
}
\description{
This function estimates a nested probit model based on a given
\code{RprobitB_fit} object.
}
\details{
All parameters (except for \code{object}) are optional and if not specified
retrieved from the specification for \code{object}.
}
